function New-Mac {
    $randStr = '{0:x6}' -F (Get-Random -Minimum 10 -Maximum 16777215)
    return "001132" + $randStr.ToUpperInvariant()
}

function New-Serial {
    Param(
        [Parameter(Mandatory = $true, Position = 0)]
        [ValidateNotNullOrEmpty()]
        [System.String] $permanent
    )

    $rand1 = (Get-Random -Minimum 11 -Maximum 14).ToString()
    $rand2 = (Get-Random -Minimum 1 -Maximum 9999).ToString().PadLeft(4, '0')
    return ($rand1 + "30" + $permanent + "N" + "00" + $rand2).ToUpperInvariant()
}

$content = Get-Content -Path "synology.json" | ConvertFrom-Json

while (1) {
    foreach ($model in $content) {
        Clear-Host
        Write-Output $model.model
        Write-Output ("SN: " + (New-Serial -permanent $model.permanent))
        Write-Output ("MAC: " + (New-Mac))
        Read-Host
    }
}

